/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Converter;

public interface Mapping<C, T extends Table<T>> {
    public Map<Column<T, ?>, ?> getInsertValues(C var1);

    public Map<UpwhereColumn<T>, ?> getUpdateValues(C var1, C var2, boolean var3);

    public C transform(ColumnedRow var1);

    public RowTransformer<C> getRowTransformer();

    default public void addShadowColumnInsert(ShadowColumnValueProvider<C, T> valueProvider) {
    }

    default public void addShadowColumnUpdate(ShadowColumnValueProvider<C, T> valueProvider) {
    }

    default public <O> void addShadowColumnSelect(Column<T, O> column) {
    }

    public void addPropertySetByConstructor(ValueAccessPoint<C> var1);

    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getPropertyToColumn();

    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getReadonlyPropertyToColumn();

    default public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
        return new ValueAccessPointMap();
    }

    default public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
        return new ValueAccessPointMap();
    }

    default public Set<Column<T, ?>> getWritableColumns() {
        return new KeepOrderSet(this.getPropertyToColumn().values());
    }

    default public Set<Column<T, ?>> getReadonlyColumns() {
        return new KeepOrderSet(this.getReadonlyPropertyToColumn().values());
    }

    default public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
    }

    public static interface ShadowColumnValueProvider<C, T extends Table<T>> {
        default public boolean accept(C entity) {
            return true;
        }

        public Set<Column<T, ?>> getColumns();

        public Map<Column<T, ?>, ?> giveValue(C var1);
    }

    public static class UpwhereColumn<T extends Table<T>> {
        private final Column<T, Object> column;
        private final boolean update;

        public static <T extends Table<T>> Set<Column<T, ?>> getUpdateColumns(Set<? extends UpwhereColumn<T>> set) {
            HashSet updateColumns = new HashSet();
            for (UpwhereColumn<T> upwhereColumn : set) {
                if (!upwhereColumn.update) continue;
                updateColumns.add(upwhereColumn.column);
            }
            return updateColumns;
        }

        public static <T extends Table<T>> Map<Column<T, Object>, ?> getUpdateColumns(Map<? extends UpwhereColumn<T>, ?> map) {
            HashMap updateColumns = new HashMap();
            for (Map.Entry<UpwhereColumn<T>, ?> entry : map.entrySet()) {
                UpwhereColumn<T> upwhereColumn = entry.getKey();
                if (!upwhereColumn.update) continue;
                updateColumns.put(upwhereColumn.column, entry.getValue());
            }
            return updateColumns;
        }

        public static <T extends Table<T>> Map<Column<T, Object>, Object> getWhereColumns(Map<? extends UpwhereColumn<T>, ?> map) {
            HashMap<Column<T, Object>, Object> updateColumns = new HashMap<Column<T, Object>, Object>();
            for (Map.Entry<UpwhereColumn<T>, ?> entry : map.entrySet()) {
                UpwhereColumn<T> upwhereColumn = entry.getKey();
                if (upwhereColumn.update) continue;
                updateColumns.put(upwhereColumn.column, entry.getValue());
            }
            return updateColumns;
        }

        public UpwhereColumn(Column<T, ?> column, boolean update) {
            this.column = column;
            this.update = update;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UpwhereColumn) {
                UpwhereColumn other = (UpwhereColumn)obj;
                return this.column.equals(other.column) && this.update == other.update;
            }
            return false;
        }

        public int hashCode() {
            return this.column.hashCode();
        }

        public String toString() {
            return this.column.getAbsoluteName() + (this.update ? " (U)" : " (W)");
        }
    }
}

